/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Id: PNM_PNIOAPCFG_Public.h 19086 2011-09-08 06:52:23Z Benjamin $
   Last Modification:
    $LastChangedBy: Benjamin $
    $LastChangedDate: 2011-09-08 08:52:23 +0200 (Do, 08 Sep 2011) $
    $LastChangedRevision: 19086 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO APCFG
    public defines

   Changes:

    Date        Author   Description
    ----------- -------- ---------------------------------------------------------
    2011-08-25  B. Meyer extended controller configuration packet PNM_APCFG_CFG_PNM_REQ_T
                            with fields  abOrderId  and  usOrderIdLen
                               (requires usage of PNM_APCFG_CFG_PNM_STRUCT_VERS_2)
                            old structure version 1 is still supported by the firmware but
                               usage of new packet is recommended
                         usage of RT_Class_2 FrameIDs for IOCRs in packet PNM_APCFG_CFG_IOCR_REQ_T
                            is now supported
                         extended interface submodule configuration packet PNM_APCFG_CFG_INTF_SUBM_REQ_T
                            with field  usMrpRole  (requires usage of PNM_APCFG_CFG_INTF_STRUCT_VERS_2)
                            old structure version 1 is still supported by the firmware but
                               usage of new packet is recommended

    2010-10-13  B. Meyer changed PNIO_API_CYCLIC_WATCHDOG_MIN to value 2 because old value 1
                            does not make sense

    2010-10-08  B. Meyer fixed corrupt definition of some #defines

    2010-09-15  B. Meyer adjusted new definitions and added little explanation

    2010-09-09  B. Meyer added definitions for FSU handling. This includes
                            extended PNM configuration dataset
                            extended IOD configuration dataset
                            new Interface Submodule configuration dataset
                            new Port Submodule configuration dataset

    2010-02-09  B. Meyer added definitions for IO-data swap configuration

    2009-12-15  B. Meyer complete rework of this file to make it more user-friendly
                            added various comments to make clear what the parameters are used for


     Version    Date        Author   Description
     ---------------------------------------------------------------------------
      7         31.03.2008  bm       added field   usObjUUIDInst   to struct   PNM_APCFG_CFG_IOD_DATAtag

      6         06.03.2007  mak      Added definition of some structures for the packet configuration via DPM

      5         23.02.2007  bm       Moved defines added in Version 4 to APCTL_public.h

      4         21.02.2007  rh       Add defines for commands

      3         13.04.2006  mg       Added fields  uiNumSubmDescrDataObj  and  uiNumSubmDescrStatObj
                                        to PNIO_APCFG_IOCR_T

      2         12.04.2006  mg       Added definition of some structures (IO-Device, IOCR, ...)

      1         21.03.2006  mg       File created

**************************************************************************************/
/**
 * @file PNIOAPCFG_Public.h
 *  PNIO APCFG - public definition of task
 *
 */
#ifndef __PNIO_APCFG_PUBLIC_H
#define __PNIO_APCFG_PUBLIC_H

#include "PNIO_spec.h"

/*************************************************************************************/
/** queue name */
#define PNIO_APCFG_QUEUE_NAME        "QUE_PNIO_APCFG"



/*
 * SUBHEADER
 */

/** subheader used by all following packets */
typedef __PACKED_PRE struct PNM_APCFG_CFG_DATA_HEADERtag
{
  /* ID of the IO-Conroller this dataset belongs to */
  TLR_UINT32              ulTrCntrId;
  /* ID of the IO-Device this dataset belongs to */
  TLR_UINT32              ulTrDevId;
  /* ID of the AP this dataset belongs to */
  TLR_UINT32              ulTrApId;
  /* ID of the module this dataset belongs to */
  TLR_UINT32              ulTrModId;
  /* ID of the submodule this dataset belongs to */
  TLR_UINT32              ulTrSubModId;
  /* amount of dataset following the header */
  TLR_UINT32              ulTrIdCnt;
} __PACKED_POST PNM_APCFG_CFG_DATA_HEADER_T;



/*
 * CONFIG IO-CONTROLLER SERVICE
 */

/** usable flags in ulSystemFlags */
/* Start mode */
#define PNM_APCFG_STARTMODE_MASK                     (0x00000001)
#define PNM_APCFG_STARTMODE_AUTO                     (0x00000000)
#define PNM_APCFG_STARTMODE_APPLICATION              (0x00000001)

/* I/O Data Status field in Dual-Port Memory - currently not supported */
#define PNM_APCFG_IODATASTAT_MASK                    (0x00000002)
#define PNM_APCFG_IODATASTAT_DISABLED                (0x00000000)
#define PNM_APCFG_IODATASTAT_ENABLED                 (0x00000002)
#define PNM_APCFG_IODATASTATLEN_MASK                 (0x00000004)
#define PNM_APCFG_IODATASTATLEN_32BIT                (0x00000000)
#define PNM_APCFG_IODATASTATLEN_8BIT                 (0x00000004)

/* IO-data format in DPM */
/* Note: not using the default value has negative impact on the performance */
#define PNM_APCFG_IODATA_DPM_FORMAT_MASK                      (0x00000008)
#define PNM_APCFG_IODATA_DPM_FORMAT_DEFAULT                   (0x00000000)
#define PNM_APCFG_IODATA_DPM_FORMAT_MSB_FIRST_BIG_ENDIAN      (0x00000000)
#define PNM_APCFG_IODATA_DPM_FORMAT_LSB_FIRST_LITTLE_ENDIAN   (0x00000008)


/* allowed values for field ulStructVersion */
#define PNM_APCFG_CFG_PNM_STRUCT_VERS_2    (2)

/* allowed values for MAUType */
/* enable Autonegotiation and AutoCrossover */
#define PNM_APCFG_PNM_MAUTYPE_AUTO         (0)
/* disable Autonegotiation and AutoCrossover, set fix 100MBit/s FullDuplex */
/* Port0 will be set to MDI, Port1 will be set to MDIX */
#define PNM_APCFG_PNM_MAUTYPE_100BASETXFD  (16)

/* allowed values for IOPSModeConsumer and IOPSModeProvider */
/* do not transfer IOxS to/from DPM */
#define PNM_APCFG_CFG_IOXS_MODE_DISABLED    (0)
/* address IOxS in DPM with bitwise access */
#define PNM_APCFG_CFG_IOXS_MODE_BITWISE     (1)
/* address IOxS in DPM with bytewise access */
#define PNM_APCFG_CFG_IOXS_MODE_BYTEWISE    (2)

/* allowed values for ulBitlistStartOffset */
/* the value needs to be a valid DPM offset */
/* the value shall not lie in between IO area */
/* the value shall not lie in between IOxS area */
/* if firmware shall automatically assign the offsets use the automatic mode */
/* automatic mode can only be used for all 3 BitLists at the same time */
/* automatic mode will put BitLists behind IOxS area */
/* the offsets can afterwards be read from extended status area */
#define PNM_APCFG_CFG_BITLIST_OFFSET_AUTOMATIC (0xFFFFFFFF)


/* extended request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32              ulTrId;
  /** SystemFlags - see above */
  TLR_UINT32              ulSystemFlags;
  /** DPM Channel Watchdog time */
  TLR_UINT32              ulWdgTime;
  /** length of TypeOfStation */
  TLR_UINT16              usTypeOfStationLen;
  TLR_UINT16              usAlign1;
  /** TypeOfStation */
  TLR_UINT8               abTypeOfStation[PNIO_MAX_TYPE_OF_STATION];
  /** length of NameOfStation */
  TLR_UINT16              usNameOfStationLen;
  /** length of OrderId */
  TLR_UINT16              usOrderIdLen;
  /** NameOfStation */
  TLR_UINT8               abNameOfStation[PNIO_MAX_NAME_OF_STATION];
  /** VendorID */
  TLR_UINT16              usVendorID;
  /** DeviceID */
  TLR_UINT16              usDeviceID;
  /** IP address */
  TLR_UINT32              ulIPAddr;
  /** subnet mask */
  TLR_UINT32              ulNetmask;
  /** Gateway address */
  TLR_UINT32              ulGateway;
  /** IP Flags - see TCPIP documentation (currently unsupported) */
  TLR_UINT32              ulIPFlags;
  /** structure version identifier - see above */
  TLR_UINT32              ulStructVersion;
  /** MAUType Port 0 */
  TLR_UINT16              usMAUTypePort0;
  /** MAUType Port 1 */
  TLR_UINT16              usMAUTypePort1;
  /** OrderId */
  TLR_UINT8               abOrderId[PNIO_MAX_ORDER_ID];

  /** IOPS mode for data consumed (Profinet Input data) - see above */
  TLR_UINT32              ulIOPSModeConsumer;
  /** offset in DPM Input area where the IOPS section for consumed IOPS shall start */
  /* this area shall not interfere with io data */
  TLR_UINT32              ulIOPSOffsetConsumer;
  /** IOPS mode for data provided (Profinet Output data) - see above */
  TLR_UINT32              ulIOPSModeProvider;
  /** offset in DPM Output area where the IOPS section for provided IOPS shall start */
  /* this area shall not interfere with io data */
  TLR_UINT32              ulIOPSOffsetProvider;

  /* IOCS mode for data consumed - currently not supported */
  TLR_UINT32              ulIOCSModeConsumer;
  /** offset in DPM Input area where the IOCS section for consumed IOCS shall start - currently not supported */
  /* this area shall not interfere with io data or the IOPS section */
  TLR_UINT32              ulIOCSOffsetConsumer;
  /* IOCS mode for data provided - currently not supported */
  TLR_UINT32              ulIOCSModeProvider;
  /** offset in DPM Output area where the IOCS section for provided IOCS shall start - currently not supported */
  /* this area shall not interfere with io data or the IOPS section */
  TLR_UINT32              ulIOCSOffsetProvider;

  /** start offset in DPM input area for slave status bitlists - see above */
  TLR_UINT32              ulBitlistStartOffset;
} __PACKED_POST PNM_APCFG_CFG_PNM_EXT_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /* IO-Controller extended configuration data */
  PNM_APCFG_CFG_PNM_EXT_DATA_T   atData[1];
} __PACKED_POST PNM_APCFG_CFG_PNM_EXT_REQ_DATA_T;

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32              ulTrId;
  /** SystemFlags - see above */
  TLR_UINT32              ulSystemFlags;
  /** DPM Channel Watchdog time */
  TLR_UINT32              ulWdgTime;
  /** length of TypeOfStation */
  TLR_UINT16              usTypeOfStationLen;
  TLR_UINT16              usAlign1;
  /** TypeOfStation */
  TLR_UINT8               abTypeOfStation[PNIO_MAX_TYPE_OF_STATION];
  /** length of NameOfStation */
  TLR_UINT16              usNameOfStationLen;
  TLR_UINT16              usAlign2;
  /** NameOfStation */
  TLR_UINT8               abNameOfStation[PNIO_MAX_NAME_OF_STATION];
  /** VendorID */
  TLR_UINT16              usVendorID;
  /** DeviceID */
  TLR_UINT16              usDeviceID;
  /** IP address */
  TLR_UINT32              ulIPAddr;
  /** subnet mask */
  TLR_UINT32              ulNetmask;
  /** Gateway address */
  TLR_UINT32              ulGateway;
  /** IP Flags - see TCPIP documentation (currently unsupported) */
  TLR_UINT32              ulIPFlags;
} __PACKED_POST PNM_APCFG_CFG_PMN_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of IO-Controller configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_PMN_DATA_T       atData[1];
} __PACKED_POST PNM_APCFG_CFG_PNM_REQ_DATA_T;

/* extended request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T               tHead;
  /** packet data */
  PNM_APCFG_CFG_PNM_EXT_REQ_DATA_T  tData;
} __PACKED_POST PNM_APCFG_CFG_PNM_EXT_REQ_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T               tHead;
  /** packet data */
  PNM_APCFG_CFG_PNM_REQ_DATA_T      tData;
} __PACKED_POST PNM_APCFG_CFG_PNM_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T          PNM_APCFG_CFG_PNM_CNF_T;

/** extended packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_PNM_EXT_REQ_T      tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_PNM_CNF_T          tCnf;
} PNM_APCFG_CFG_PNM_EXT_PCK_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_PNM_REQ_T          tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_PNM_CNF_T          tCnf;
} PNM_APCFG_CFG_PNM_PCK_T;

/*
 * CONFIG IO-DEVICE SERVICE
 */

/** usable flags in ulFlags */
/* shall the IO-Device of the dataset be active or inactive? */
/* inactive means the IO-Controller will NOT try to connect to it */
#define PNM_APCFG_IOD_FLAG_IOD_INACTIVE     (0x00000000)
#define PNM_APCFG_IOD_FLAG_IOD_ACTIVE       (0x00000001)

/* AR Types */
#define PNIO_API_AR_TYPE_SINGLE             (0x0001)  /**< IOCARSingle */

/* AR Properties */
#define PNIO_API_AR_PROP_STATE_MASK         (0x0007)  /**< State mask */
#define PNIO_API_AR_PROP_STATE_BACKUP       (0x0000)  /**< backup */ /* not supported */
#define PNIO_API_AR_PROP_STATE_PRIMARY      (0x0001)  /**< primary */

#define PNIO_API_AR_PROP_SUPERVISOR_MASK    (0x0008)  /**< SupervisorTakeoverAllowed mask */
#define PNIO_API_AR_PROP_SUPERVISOR_NONE    (0x0000)  /**< takeover not allowed */
#define PNIO_API_AR_PROP_SUPERVISOR_ALLOWED (0x0008)  /**< takeover allowed */ /* not supported */

#define PNIO_API_AR_PROP_COMP_AR_MASK       (0x0600)  /**< Companion AR mask */
#define PNIO_API_AR_PROP_SINGLE_AR          (0x0000)  /**< single AR */
#define PNIO_API_AR_PROP_FIRST_AR           (0x0001)  /**< first of 2 AR */ /* not supported */
#define PNIO_API_AR_PROP_COMPANION_AR       (0x0002)  /**< second of 2 AR */ /* not supported */

/* Alarm CR Type */
#define PNIO_API_ALCR_TYPE_ALARM            (0x0001)  /**< Alarm CR */

/* Alarm CR Properties */
#define PNIO_API_ALCR_PROP_PRIO_MASK        (0x0001)  /**< Priority mask */
#define PNIO_API_ALCR_PROP_PRIO_DEFAULT     (0x0000)  /**< use default priority */
#define PNIO_API_ALCR_PROP_PRIO_LOW         (0x0001)  /**< use low priority */

/* RTA Retries */
#define PNIO_API_RTA_RETRIES_MIN            (0x0003)  /**< minimum value allowed for RTA retries */
#define PNIO_API_RTA_RETRIES_MAX            (0x000F)  /**< maximum value allowed for RTA retries */

/* allowed values for field ulStructureVersion */
#define PNM_APCFG_CFG_IOD_STRUCT_VERS_1          (1)

/* allowed values for field ulFSParamMode */
#define PNM_APCFG_CFG_FSPARAM_MODE_DISABLE       (0)
#define PNM_APCFG_CFG_FSPARAM_MODE_ENABLE        (1)


/** extended request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32              ulTrId;
  /** flags - see above */
  TLR_UINT32              ulFlags;
  /** length of NameOfStation */
  TLR_UINT16              usNameOfStationLen;
  TLR_UINT16              usAlign1;
  /** NameOfStation */
  TLR_UINT8               abNameOfStation[PNIO_MAX_NAME_OF_STATION];
  /** VendorID */
  TLR_UINT16              usVendorID;
  /** DeviceID */
  TLR_UINT16              usDeviceID;
  /** IP Flags - currently not supported */
  TLR_UINT32              ulIPFlags;
  /** IP address */
  TLR_UINT32              ulIPAddr;
  /** network mask */
  TLR_UINT32              ulNetworkMask;
  /** Gateway address */
  TLR_UINT32              ulGatewayAddr;
  /** AR UUID - has to be unique over all configured IO-Devices */
  TLR_UINT32              ulArUuidData1;
  TLR_UINT16              usArUuidData2;
  TLR_UINT16              usArUuidData3;
  TLR_UINT8               abArUuidData4[8];
  /** AR Type - see above */
  TLR_UINT16              usARType;
  TLR_UINT16              usAlign2;
  /** AR Properties - see above */
  TLR_UINT32              ulARProp;
  /** Alarm CR Type - see above */
  TLR_UINT16              usAlarmCRType;
  TLR_UINT16              usAlign3;
  /** Alarm CR Properties - see above */
  TLR_UINT32              ulAlarmCRProp;
  /** Alarm CR VLAN ID */
  TLR_UINT16              usAlarmCRVLANID;
  /* RTA Timeout Factor */
  TLR_UINT16              usRTATimeoutFact;
  /** RTA Retries */
  TLR_UINT16              usRTARetries;
  TLR_UINT16              usAlign4;
  /** ObjectUUID Instance (GSDML parameter) */
  TLR_UINT16              usObjUUIDInst;
  TLR_UINT16              usAlign5;

  /** structure version */
  TLR_UINT32              ulStructVersion;
  /* FSU related block following */
  /** FSParameterMode - see above */
  TLR_UINT32              ulFSParamMode;
  /** FSParameter UUID - irrelevant if FSParamMode is set to off */
  TLR_UINT32              ulFSParamUuidData1;
  TLR_UINT16              usFSParamUuidData2;
  TLR_UINT16              usFSParamUuidData3;
  TLR_UINT8               abFSParamUuidData4[8];
  /** does the IO-Device support Multiple Write ? */
  /* Note: The IO-Controller implementation does not yet support this feature ! */
  TLR_BOOLEAN32           fIsWriteMultipeSupported;
} __PACKED_POST PNM_APCFG_CFG_IOD_EXT_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of IO-Device configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_IOD_EXT_DATA_T   atData[1];
} __PACKED_POST PNM_APCFG_CFG_IOD_EXT_REQ_DATA_T;

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32              ulTrId;
  /** flags - see above */
  TLR_UINT32              ulFlags;
  /** length of NameOfStation */
  TLR_UINT16              usNameOfStationLen;
  TLR_UINT16              usAlign1;
  /** NameOfStation */
  TLR_UINT8               abNameOfStation[PNIO_MAX_NAME_OF_STATION];
  /** VendorID */
  TLR_UINT16              usVendorID;
  /** DeviceID */
  TLR_UINT16              usDeviceID;
  /** IP Flags - currently not supported */
  TLR_UINT32              ulIPFlags;
  /** IP address */
  TLR_UINT32              ulIPAddr;
  /** network mask */
  TLR_UINT32              ulNetworkMask;
  /** Gateway address */
  TLR_UINT32              ulGatewayAddr;
  /** AR UUID - has to be unique over all configured IO-Devices */
  TLR_UINT32              ulArUuidData1;
  TLR_UINT16              usArUuidData2;
  TLR_UINT16              usArUuidData3;
  TLR_UINT8               abArUuidData4[8];
  /** AR Type - see above */
  TLR_UINT16              usARType;
  TLR_UINT16              usAlign2;
  /** AR Properties - see above */
  TLR_UINT32              ulARProp;
  /** Alarm CR Type - see above */
  TLR_UINT16              usAlarmCRType;
  TLR_UINT16              usAlign3;
  /** Alarm CR Properties - see above */
  TLR_UINT32              ulAlarmCRProp;
  /** Alarm CR VLAN ID */
  TLR_UINT16              usAlarmCRVLANID;
  /* RTA Timeout Factor */
  TLR_UINT16              usRTATimeoutFact;
  /** RTA Retries */
  TLR_UINT16              usRTARetries;
  TLR_UINT16              usAlign4;
  /** ObjectUUID Instance (GSDML parameter) */
  TLR_UINT16              usObjUUIDInst;
  TLR_UINT16              usAlign5;
} __PACKED_POST PNM_APCFG_CFG_IOD_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of IO-Device configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_IOD_DATA_T      atData[1];
} __PACKED_POST PNM_APCFG_CFG_IOD_REQ_DATA_T;

/** extended request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T              tHead;
  /** packet data */
  PNM_APCFG_CFG_IOD_EXT_REQ_DATA_T tData;
} __PACKED_POST PNM_APCFG_CFG_IOD_EXT_REQ_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T              tHead;
  /** packet data */
  PNM_APCFG_CFG_IOD_REQ_DATA_T     tData;
} __PACKED_POST PNM_APCFG_CFG_IOD_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T         PNM_APCFG_CFG_IOD_CNF_T;

/** extended packet union */
typedef union
{
  /** extended request packet */
  PNM_APCFG_CFG_IOD_EXT_REQ_T      tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_IOD_CNF_T          tCnf;
} PNM_APCFG_CFG_IOD_EXT_PCK_T;


/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_IOD_REQ_T          tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_IOD_CNF_T          tCnf;
} PNM_APCFG_CFG_IOD_PCK_T;


/*
 * CONFIGURE IOCR SERVICE
 */

/* IOCR Type */
#define PNIO_API_IOCR_TYPE_MASK             (0x0007)  /**< Type mask */
#define PNIO_API_IOCR_TYPE_INPUT            (0x0001)  /**< input (consumer) */
#define PNIO_API_IOCR_TYPE_OUTPUT           (0x0002)  /**< output (provider) */

/* IOCR Properties */
#define PNIO_API_IOCR_PROP_RTCLASS_MASK     (0x000F)  /**< RTClass mask */
#define PNIO_API_IOCR_PROP_RTCLASS_DATA1    (0x0001)  /**< RTClass1 Data-RTC-PDU */
#define PNIO_API_IOCR_PROP_RTCLASS_DATA2    (0x0002)  /**< RTClass2 Data-RTC-PDU */
#define PNIO_API_IOCR_PROP_RTCLASS_DATA3    (0x0003)  /**< RTClass3 Data-RTC-PDU */ /* not supported */
#define PNIO_API_IOCR_PROP_RTCLASS_UDP1     (0x0004)  /**< RTClass1 UDP-RTC-PDU */  /* not supported */

/* SendClockFactor */
#define PNIO_API_SEND_CLOCK_DEFAULT         (0x0020)  /**< default value for SendClockFactor */
#define PNIO_API_SEND_CLOCK_MIN             (0x0020)  /**< minimum value allowed for SendClockFactor */
#define PNIO_API_SEND_CLOCK_MAX             (0x0080)  /**< maximum value allowed for SendClockFactor */

/* ReductionRatio */
/* the possible values depend on SendClock */
#define PNIO_API_REDUCT_RATIO_MIN           (0x0001)  /**< minimum value allowed for ReductionRatio */
#define PNIO_API_REDUCT_RATIO_MAX           (0x0200)  /**< maximum value allowed for ReductionRatio */

/* Phase */
/* the possible values depend on SendClock and ReductionRatio */
#define PNIO_API_PHASE_VALUE_MIN            (0x0001)  /**< minimum value allowed for Phase */
#define PNIO_API_PHASE_VALUE_MAX            (0x4000)  /**< maximum value allowed for Phase */

/* FrameSendOffset */
#define PNIO_API_FRAME_SEND_OFFSET_DEFAULT  (0xFFFFFFFF) /**< best practice, default value */

/* Watchdog Factor */
#define PNIO_API_CYCLIC_WATCHDOG_DEFAULT    (0x0003)  /**< default value for Watchdog factor */
#define PNIO_API_CYCLIC_WATCHDOG_MIN        (0x0002)  /**< minimum value allowed for Watchdog factor */
#define PNIO_API_CYCLIC_WATCHDOG_MAX        (0x1E00)  /**< maximum value allowed for Watchdog factor */

/* DataHold Factor */
#define PNIO_API_CYCLIC_DATAHOLD_DEFAULT    (0x0003)  /**< default value for datahold factor */
#define PNIO_API_CYCLIC_DATAHOLD_MIN        (0x0001)  /**< minimum value allowed for datahold factor */
#define PNIO_API_CYCLIC_DATAHOLD_MAX        (0x1E00)  /**< maximum value allowed for datahold factor */

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* IOCR type - see above */
  TLR_UINT16                usType;
  /* IOCR VLAN ID */
  TLR_UINT16                usVLANID;
  /* IOCR properties- see above */
  TLR_UINT32                ulProp;
  /* IOCR multicast MAC address - currently unsupported */
  TLR_UINT8                 abMcastMACAddr[PNIO_LEN_MAC_ADDR];
  /* IOCR data length */
  TLR_UINT16                usDataLen;
  /* IOCR sendclock factor - see above */
  TLR_UINT16                usSendClockFact;
  /* IOCR reduction ratio - see above */
  TLR_UINT16                usReductRatio;
  /* IOCR phase - see above */
  TLR_UINT16                usPhase;
  /* IOCR sequence number */
  TLR_UINT16                usSequ;
  /* IOCR FrameSendOffset - see above */
  TLR_UINT32                ulFrameSendOffs;
  /* IOCR watchdog factor - see above */
  TLR_UINT16                usWatchdogFact;
  /* IOCR datahold factor - see above */
  TLR_UINT16                usDataHoldFact;
} __PACKED_POST PNM_APCFG_CFG_IOCR_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of IOCR configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_IOCR_DATA_T      atData[1];
} __PACKED_POST PNM_APCFG_CFG_IOCR_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T          tHead;
  /** packet data */
  PNM_APCFG_CFG_IOCR_REQ_DATA_T      tData;
} __PACKED_POST PNM_APCFG_CFG_IOCR_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T    PNM_APCFG_CFG_IOCR_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_IOCR_REQ_T          tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_IOCR_CNF_T          tCnf;
} PNM_APCFG_CFG_IOCR_PCK_T;


/*
 * CONFIGURE AP SERVICE
 */

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* the API of this AP */
  TLR_UINT32                ulAPI;
} __PACKED_POST PNM_APCFG_CFG_AP_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of AP configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_AP_DATA_T      atData[1];
} __PACKED_POST PNM_APCFG_CFG_AP_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T              tHead;
  /** packet data */
  PNM_APCFG_CFG_AP_REQ_DATA_T      tData;
} __PACKED_POST PNM_APCFG_CFG_AP_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T         PNM_APCFG_CFG_AP_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_AP_REQ_T      tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_AP_CNF_T      tCnf;
} PNM_APCFG_CFG_AP_PCK_T;


/*
 * CONFIGURE MODULE SERVICE
 */

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* module identifier according to GSDML */
  TLR_UINT32                ulModuleID;
  /* module properties - not yet defined */
  TLR_UINT16                usModuleProp;
  /* slot the module is expected in */
  TLR_UINT16                usSlotNumber;
} __PACKED_POST PNM_APCFG_CFG_MODULE_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of Module configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_MODULE_DATA_T    atData[1];
} __PACKED_POST PNM_APCFG_CFG_MODULE_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                tHead;
  /** packet data */
  PNM_APCFG_CFG_MODULE_REQ_DATA_T    tData;
} __PACKED_POST PNM_APCFG_CFG_MODULE_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T            PNM_APCFG_CFG_MODULE_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_MODULE_REQ_T    tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_MODULE_CNF_T    tCnf;
} PNM_APCFG_CFG_MODULE_PCK_T;


/*
 * CONFIGURE SUBMODULE SERVICE
 */

/* Submodule Properties */
#define PNIO_API_SUBM_PROP_TYPE_MASK        (0x0003)  /**< Type mask */
#define PNIO_API_SUBM_PROP_TYPE_NONE        (0x0000)  /**< no input and no output */
#define PNIO_API_SUBM_PROP_TYPE_INPUT       (0x0001)  /**< input */
#define PNIO_API_SUBM_PROP_TYPE_OUTPUT      (0x0002)  /**< output */
#define PNIO_API_SUBM_PROP_TYPE_BOTH        (0x0003)  /**< input and output */


/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* submodule identifier according to GSDML */
  TLR_UINT32                ulSubmoduleID;
  /* submodule properties - see above */
  TLR_UINT16                usSubmoduleProp;
  /* subslot the submodule is expected in */
  TLR_UINT16                usSubslotNumber;
} __PACKED_POST PNM_APCFG_CFG_SUBMODULE_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of Subdmodule configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_SUBMODULE_DATA_T  atData[1];
} __PACKED_POST PNM_APCFG_CFG_SUBMODULE_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                 tHead;
  /** packet data */
  PNM_APCFG_CFG_SUBMODULE_REQ_DATA_T  tData;
} __PACKED_POST PNM_APCFG_CFG_SUBMODULE_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T             PNM_APCFG_CFG_SUBMODULE_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_SUBMODULE_REQ_T    tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_SUBMODULE_CNF_T    tCnf;
} PNM_APCFG_CFG_SUBMODULE_PCK_T;


/*
 * CONFIGURE SUBMODULEDESCRIPTION SERVICE
 */

/* Submodule Data description */
/* submodules with both, input and output data need 2 submodule description datasets */
/* submodules without IO-data shall be configured with data description input */
#define PNIO_API_SUBMDESCR_DATA_DESCR_MASK   (0x0003)
#define PNIO_API_SUBMDESCR_DATA_DESCR_INPUT  (0x0001)
#define PNIO_API_SUBMDESCR_DATA_DESCR_OUTPUT (0x0002)

/* allowed values for field ulStructVersion */
#define PNM_APCFG_CFG_SUBMDESCR_STRUCT_VERS_1          (1)

/** extended request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* submodule data description - see above */
  TLR_UINT16                usDataDescr;
  /* total submodule data length */
  TLR_UINT16                usSubmDataLen;
  /* TreeIdentifier of the producer IOCR */
  TLR_UINT32                ulIOCRIdProd;
  /* TreeIdentifier of the consumer IOCR */
  TLR_UINT32                ulIOCRIdCons;
  /* length of IOPS */ /* currently only 1 is supported */
  TLR_UINT8                 bIOPSLen;
  /* length of IOCS */ /* currently only 1 is supported */
  TLR_UINT8                 bIOCSLen;
  TLR_UINT16                usAlign1;
  /* offset inside the frame where the data of this submodule description shall reside */
  TLR_UINT16                usFrameOffs;
  /* offset inside the frame where IOCS of this submodule description shall reside */
  /* Note: usFrameOffs and usIOCSFrameOffs describe offsets in DIFFERENT cyclic frames ! */
  TLR_UINT16                usIOCSFrameOffs;
  /* IO block in DPM */ /* currently not supported */
  TLR_UINT32                ulIO_Block;
  /* offset in DPM where IO-data of this submodule description shall be copied to / taken from */
  TLR_UINT32                ulDPM_OffsetData;
  /* signal attributes of this submodule description */ /* currently not supported */
  TLR_UINT32                ulSignal_Attrib;
  /** structure version - see above */
  TLR_UINT32                ulStructVersion;
  /* offset in DPM where IOPS of this submodule description shall be copied to / taken from */
  /* Note: the offset is in relation to the IOxS offset specified in PNM_APCFG_CFG_PNM_EXT_REQ_T */
  /* Note: this offset counts bits, even if IOPS byte mode is activated */
  /* Note: in case of PNIO_API_SUBMDESCR_DATA_DESCR_OUTPUT this offset references where status is taken from */
  /* Note: in case of PNIO_API_SUBMDESCR_DATA_DESCR_INPUT  this offset references where status is copied to */
  TLR_UINT32                ulDPM_OffsetIopsBit;
  /* IOCS bit offset - currently not supported */
  TLR_UINT32                ulDPM_OffsetIocsBit;
} __PACKED_POST PNM_APCFG_CFG_SUBMDESCR_DATA_EXT_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T         tSubHead;
  /** Array of SubmoduleDescription configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_SUBMDESCR_DATA_EXT_T  atData[1];
} __PACKED_POST PNM_APCFG_CFG_SUBMDESCR_REQ_DATA_EXT_T;

/** extended request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                     tHead;
  /** packet data */
  PNM_APCFG_CFG_SUBMDESCR_REQ_DATA_EXT_T  tData;
} __PACKED_POST PNM_APCFG_CFG_SUBMDESCR_REQ_EXT_T;


/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* submodule data description - see above */
  TLR_UINT16                usDataDescr;
  /* total submodule data length */
  TLR_UINT16                usSubmDataLen;
  /* TreeIdentifier of the producer IOCR */
  TLR_UINT32                ulIOCRIdProd;
  /* TreeIdentifier of the consumer IOCR */
  TLR_UINT32                ulIOCRIdCons;
  /* length of IOPS */ /* currently only 1 is supported */
  TLR_UINT8                 bIOPSLen;
  /* length of IOCS */ /* currently only 1 is supported */
  TLR_UINT8                 bIOCSLen;
  TLR_UINT16                usAlign1;
  /* offset inside the frame where the data of this submodule description shall reside */
  TLR_UINT16                usFrameOffs;
  /* offset inside the frame where IOCS of this submodule description shall reside */
  /* Note: usFrameOffs and usIOCSFrameOffs describe offsets in DIFFERENT cyclic frames ! */
  TLR_UINT16                usIOCSFrameOffs;
  /* IO block in DPM */ /* currently not supported */
  TLR_UINT32                ulIO_Block;
  /* offset in DPM where IO-data of this submodule description shall be copied to / taken from */
  TLR_UINT32                ulDPM_Offset;
  /* signal attributes of this submodule description */ /* currently not supported */
  TLR_UINT32                ulSignal_Attrib;
} __PACKED_POST PNM_APCFG_CFG_SUBMDESCR_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** Array of SubmoduleDescription configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_SUBMDESCR_DATA_T  atData[1];
} __PACKED_POST PNM_APCFG_CFG_SUBMDESCR_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                 tHead;
  /** packet data */
  PNM_APCFG_CFG_SUBMDESCR_REQ_DATA_T  tData;
} __PACKED_POST PNM_APCFG_CFG_SUBMDESCR_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T            PNM_APCFG_CFG_SUBMDESCR_CNF_T;

/** extended packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_SUBMDESCR_REQ_EXT_T    tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_SUBMDESCR_CNF_T        tCnf;
} PNM_APCFG_CFG_SUBMDESCR_PCK_EXT_T;


/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_SUBMDESCR_REQ_T    tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_SUBMDESCR_CNF_T    tCnf;
} PNM_APCFG_CFG_SUBMDESCR_PCK_T;


/*
 * CONFIGURE INTERFACE SUBMODULE SERVICE
 */

/* allowed values for field ulStructureVersion */
#define PNM_APCFG_CFG_INTF_STRUCT_VERS_2             (2)

/* allowed values for field ulFSHelloMode */
#define PNM_APCFG_CFG_HELLO_MODE_OFF                 (0)
#define PNM_APCFG_CFG_HELLO_MODE_HELLO_ON_LINKUP     (1)
#define PNM_APCFG_CFG_HELLO_MODE_HELLO_AFTER_DELAY   (2)

/* allowed values for field ulFSHelloInterval */
#define PNM_APCFG_CFG_HELLO_INTERVAL_30MS            (30)
#define PNM_APCFG_CFG_HELLO_INTERVAL_50MS            (50)
#define PNM_APCFG_CFG_HELLO_INTERVAL_100MS           (100)
#define PNM_APCFG_CFG_HELLO_INTERVAL_300MS           (300)
#define PNM_APCFG_CFG_HELLO_INTERVAL_500MS           (500)
#define PNM_APCFG_CFG_HELLO_INTERVAL_1000MS          (1000)

/* allowed values for field ulFSHelloRetry */
#define PNM_APCFG_CFG_HELLO_RETRY_DEFAULT            (3)
#define PNM_APCFG_CFG_HELLO_RETRY_MIN                (1)
#define PNM_APCFG_CFG_HELLO_RETRY_MAX                (15)

/* allowed values for field ulFSHelloDelay */
/* value unequal to OFF only valid if HelloMode is PNM_APCFG_CFG_HELLO_MODE_HELLO_AFTER_DELAY */
#define PNM_APCFG_CFG_HELLO_DELAY_OFF                (0)
#define PNM_APCFG_CFG_HELLO_DELAY_50MS               (50)
#define PNM_APCFG_CFG_HELLO_DELAY_100MS              (100)
#define PNM_APCFG_CFG_HELLO_DELAY_500MS              (500)
#define PNM_APCFG_CFG_HELLO_DELAY_1000MS             (1000)

/* allowed values for field usMrpRole */
#define PNM_APCFG_CFG_MRP_ROLE_NOT_SUPPORTED         (0xFFFF)
#define PNM_APCFG_CFG_MRP_ROLE_MRP_DISABLED          (0x0000)

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /** structure version */
  TLR_UINT32                ulStructVersion;
  /* FSU related block follows */
  /** FSU enable? */
  TLR_BOOLEAN32             fEnableFsu;
  /** FSU HelloMode - see above */
  TLR_UINT32                ulFSHelloMode;
  /** FSU HelloInterval - see above */
  TLR_UINT32                ulFSHelloInterval;
  /** FSU HelloRetry - see above */
  TLR_UINT32                ulFSHelloRetry;
  /** FSU HelloDelay - see above */
  TLR_UINT32                ulFSHelloDelay;
  /** MRP role - see above */
  /* Note: The feature MRP is not supported by current IO-Controller implementation.
   *       However the information if the Device supports MRP is required to be available
   *       at runtime inside IO-Controller to fulfill certification requirements.
   */
  TLR_UINT16                usMrpRole;
} __PACKED_POST PNM_APCFG_CFG_INTF_SUBM_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T         tSubHead;
  /** Array of PDEV configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_INTF_SUBM_DATA_T      atData[1];
} __PACKED_POST PNM_APCFG_CFG_INTF_SUBM_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                     tHead;
  /** packet data */
  PNM_APCFG_CFG_INTF_SUBM_REQ_DATA_T      tData;
} __PACKED_POST PNM_APCFG_CFG_INTF_SUBM_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T    PNM_APCFG_CFG_INTF_SUBM_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_INTF_SUBM_REQ_T          tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_INTF_SUBM_CNF_T          tCnf;
} PNM_APCFG_CFG_INTF_SUBM_PCK_T;


/*
 * CONFIGURE PORT SUBMODULE SERVICE
 */

/* allowed values for field ulStructureVersion */
#define PNM_APCFG_CFG_PORT_STRUCT_VERS_1      (1)

/* allowed valued for field ulAdjustFlags */
/* default value */
#define PNM_APCFG_CFG_PORT_ADJUST_DEFAULT     (0)
/* allowed bits to set in flag field */
#define PNM_APCFG_CFG_PORT_ADJUST_MAUTYPE     (1)

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /** structure version */
  TLR_UINT32                ulStructVersion;
  /** flags which parameters shall be adjusted adjust - see above */
  TLR_UINT32                ulAdjustFlags;
  /** MAUType to adjust */
  TLR_UINT16                usAdjustMauType;
} __PACKED_POST PNM_APCFG_CFG_PORT_SUBM_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T         tSubHead;
  /** Array of PDEV configuration data, amount of datasets depends on tSubHead.ulTrIdCnt */
  PNM_APCFG_CFG_PORT_SUBM_DATA_T      atData[1];
} __PACKED_POST PNM_APCFG_CFG_PORT_SUBM_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                     tHead;
  /** packet data */
  PNM_APCFG_CFG_PORT_SUBM_REQ_DATA_T      tData;
} __PACKED_POST PNM_APCFG_CFG_PORT_SUBM_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T    PNM_APCFG_CFG_PORT_SUBM_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_PORT_SUBM_REQ_T          tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_PORT_SUBM_CNF_T          tCnf;
} PNM_APCFG_CFG_PORT_SUBM_PCK_T;


/*
 * CONFIGURE RECORD SERVICE
 */

/** request packet data */
typedef __PACKED_PRE struct
{
  /** tree identifier of this dataset */
  TLR_UINT32                ulTrId;
  /* the index of the record - defined in GSDML */
  TLR_UINT16                usIndex;
  TLR_UINT16                usAlign1;
  /* the length of the record data - defined in GSDML */
  TLR_UINT32                ulDataLen;
  /** Array of Record Data, sizeof array depend on parameter ulDataLen  */
  TLR_UINT8                 abRecordData[1];
} __PACKED_POST PNM_APCFG_CFG_RECORD_DATA_T;

typedef __PACKED_PRE struct
{
  /** data header */
  PNM_APCFG_CFG_DATA_HEADER_T    tSubHead;
  /** record dataset */
  PNM_APCFG_CFG_RECORD_DATA_T    tRecord;
} __PACKED_POST PNM_APCFG_CFG_RECORD_REQ_DATA_T;

/** request packet */
typedef __PACKED_PRE struct
{
  /** packet header */
  TLR_PACKET_HEADER_T                tHead;
  /** packet data */
  PNM_APCFG_CFG_RECORD_REQ_DATA_T    tData;
} __PACKED_POST PNM_APCFG_CFG_RECORD_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T            PNM_APCFG_CFG_RECORD_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_CFG_RECORD_REQ_T    tReq;
  /** confirmation packet */
  PNM_APCFG_CFG_RECORD_CNF_T    tCnf;
} PNM_APCFG_CFG_RECORD_PCK_T;


/*
 * DOWNLOAD FINISHED SERVICE
 */

/** request packet */
typedef TLR_EMPTY_PACKET_T   PNM_APCFG_DWNL_FIN_REQ_T;

/** confirmation packet */
typedef TLR_EMPTY_PACKET_T   PNM_APCFG_DWNL_FIN_CNF_T;

/** packet union */
typedef union
{
  /** request packet */
  PNM_APCFG_DWNL_FIN_REQ_T    tReq;
  /** confirmation packet */
  PNM_APCFG_DWNL_FIN_CNF_T    tCnf;
} PNM_APCFG_DWNL_FIN_PCK_T;


/*************************************************************************************/
#endif /* #ifndef __PNIO_APCFG_PUBLIC_H */
